#ifndef _READINGDLG_CPP
#define _READINGDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <ShlOBJ.H>
#include <Stdlib.H>

#include "../Resources/Resource.H"

#include "../Headers/NSWFL.H"
#include "../Headers/Package.H"
#include "../Headers/Entry.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/OpenPassDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND ReadingDialog_hWnd = NULL;
HWND ReadingStatusText_hWnd = NULL;
HWND ReadingStatusBar_hWnd = NULL;
HWND ReadingMulButton_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK ReadingDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HMENU SystemMenu = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
    {
        ReadingDialog_hWnd = xHandle;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        ReadingStatusText_hWnd = GetDlgItem(xHandle, IDC_STATUSTEXT);
        ReadingStatusBar_hWnd = GetDlgItem(xHandle, IDC_PROGRESS);
        ReadingMulButton_hWnd = GetDlgItem(xHandle, IDC_MULBUTTON);

        SendMessage(ReadingStatusBar_hWnd, PBM_SETPOS, 0, (LPARAM) 0);

        CenterWindow(xHandle);

        ResumeThread(Worker_Thread_Handle);

        SetTimer(xHandle, 0, 100, NULL);

        return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_TIMER)
    {
        SendMessage(ReadingStatusBar_hWnd, PBM_SETPOS, PackageProgress, (LPARAM) 0);
        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
        if(wParam == IDC_MULBUTTON)
        {
            if(gdwCurrentJobType == 0)
            {
                EndDialog(xHandle, 0);
                DestroyWindow(xHandle);
            }
            else{
                EnableWindow(ReadingMulButton_hWnd, FALSE);
                Set_Text(ReadingStatusText_hWnd, "Please wait... Cancelling.");
                gdwCurrentJobType = JOB_TYPE_CANCEL;
            }
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        EndDialog(xHandle, 0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

